/* global cx, sc, sca */

let objects = require('common/objects');
let PDDocument = Packages.org.apache.pdfbox.pdmodel.PDDocument;
let PDPage = Packages.org.apache.pdfbox.pdmodel.PDPage;
let PdfLoader = Packages.agorum.roi.pdf.PdfLoader;
let PDDocumentOutline = Packages.org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
let PDOutlineItem = Packages.org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;

let obj = objects.find(1103300);

let document = PDDocument.load(obj.contentStream);
let newPage = new PDPage(); // OK
document.addPage(newPage); // OK
let numberOfPages = document.getNumberOfPages(); // OK
console.log('numberOfPages', numberOfPages);

// let page = document.getPage(0); // ERROR

let catalog = document.getDocumentCatalog();
let pages = catalog.getAllPages();
let page = pages.get(0); // OK

let outline = new PDDocumentOutline();
catalog.setDocumentOutline(outline);
let outlineItem = new PDOutlineItem();
outlineItem.setTitle('MyBookmark');
outlineItem.setDestination(page);
// outline.addLast(outlineItem); // ERROR

document.save(obj.contentOutputStream);
document.close();
